# HMPC URL Shortener Chrome Extension

현재 페이지를 hmpc.uk 단축 URL로 변환하고 클립보드에 자동으로 복사해주는 Chrome Extension입니다.

## 🎯 주요 기능

- ✨ **원클릭 단축**: 익스텐션 아이콘 클릭으로 현재 페이지를 즉시 단축
- 📋 **자동 복사**: 생성된 단축 URL이 자동으로 클립보드에 복사됨
- 🎨 **커스텀 ID**: 원하는 커스텀 ID 지정 가능
- 📝 **메모 기능**: 단축 URL에 메모 추가 가능
- 🔄 **페이지 정보 자동 인식**: 현재 페이지의 제목과 URL 자동 인식

## 📦 설치 방법

### 1. Chrome 개발자 모드로 설치

1. Chrome 브라우저에서 `chrome://extensions/` 접속
2. 오른쪽 상단의 **개발자 모드** 활성화
3. **압축해제된 확장 프로그램을 로드합니다** 클릭
4. 이 폴더(`chrome-extention`) 선택
5. 설치 완료!

### 2. 패키징하여 설치 (옵션)

```bash
# 1. chrome://extensions/에서 "확장 프로그램 패키징" 클릭
# 2. 확장 프로그램 루트 디렉터리로 chrome-extention 폴더 선택
# 3. 생성된 .crx 파일을 드래그 앤 드롭
```

## 🚀 사용 방법

### 기본 사용

1. 단축하고 싶은 웹페이지로 이동
2. Chrome 툴바의 HMPC URL Shortener 아이콘 클릭
3. 팝업이 열리면 현재 페이지 정보 확인
4. **단축하고 복사하기** 버튼 클릭
5. 단축 URL이 생성되고 자동으로 클립보드에 복사됨!

### 커스텀 ID 사용

1. 익스텐션 팝업 열기
2. "커스텀 ID" 필드에 원하는 ID 입력 (예: `mylink`)
3. 단축하기 버튼 클릭
4. `https://hmpc.uk/mylink` 형태로 생성됨

### 메모 추가

1. 익스텐션 팝업 열기
2. "메모" 필드에 메모 입력
3. 단축하기 버튼 클릭
4. 메모는 웹 인터페이스의 목록에서 확인 가능

## 🛠️ 기술 스택

- **Manifest V3**: 최신 Chrome Extension API 사용
- **Vanilla JavaScript**: 가볍고 빠른 성능
- **Chrome Tabs API**: 현재 탭 정보 접근
- **Clipboard API**: 자동 복사 기능

## 📁 파일 구조

```
chrome-extention/
├── manifest.json       # Chrome Extension 설정
├── popup.html          # 팝업 UI
├── popup.js           # 팝업 로직
├── popup.css          # 팝업 스타일
├── icons/             # 아이콘 이미지
│   ├── icon16.png     # 16x16 아이콘
│   ├── icon48.png     # 48x48 아이콘
│   └── icon128.png    # 128x128 아이콘
└── README.md          # 문서
```

## 🎨 디자인

- Frontend와 동일한 디자인 시스템 적용
- Primary Color: #6366f1 (Indigo)
- 400px 고정 너비의 깔끔한 팝업 UI
- 부드러운 애니메이션 효과

## 🔐 권한 설명

이 익스텐션은 다음 권한을 사용합니다:

- **activeTab**: 현재 활성화된 탭의 정보(URL, 제목)를 읽기 위해 필요
- **clipboardWrite**: 생성된 단축 URL을 클립보드에 복사하기 위해 필요

## 🔗 API 연동

Backend API (`https://hmpc.uk`)와 연동하여 동작합니다.

### 사용하는 엔드포인트

- `POST /api/shorten` - URL 단축 생성

자세한 API 문서는 [Backend README](/workers/README.md)를 참고하세요.

## 🐛 트러블슈팅

### 익스텐션이 작동하지 않음

1. `chrome://extensions/`에서 익스텐션이 활성화되어 있는지 확인
2. 개발자 모드가 켜져 있는지 확인
3. 페이지를 새로고침하고 다시 시도

### 페이지 정보를 불러올 수 없음

- `chrome://` 또는 `edge://` 등의 내부 페이지에서는 작동하지 않습니다
- 일반 웹페이지(http/https)에서만 사용 가능합니다

### 복사가 안 됨

- Chrome의 클립보드 권한이 허용되어 있는지 확인
- 팝업이 열린 상태에서만 복사가 가능합니다

### CORS 에러

- Backend API에서 CORS가 활성화되어 있는지 확인
- `https://hmpc.uk` 서버가 정상 작동 중인지 확인

## 📝 개발 가이드

### 코드 수정 후 테스트

1. 코드 수정
2. `chrome://extensions/`에서 새로고침 버튼 클릭
3. 익스텐션 아이콘 클릭하여 테스트

### 디버깅

1. 익스텐션 팝업에서 우클릭 > "검사" 클릭
2. DevTools에서 콘솔 로그 확인
3. Network 탭에서 API 요청 확인

### API URL 변경

```javascript
// popup.js
const API_BASE_URL = "https://your-domain.com";
```

## 🎁 배포

### Chrome Web Store에 배포

1. [Chrome Web Store Developer Dashboard](https://chrome.google.com/webstore/devconsole) 접속
2. 새 항목 추가 클릭
3. 익스텐션 zip 파일 업로드
4. 스크린샷, 설명 등 추가
5. 제출 및 검토 대기

### 로컬 배포

현재 폴더를 그대로 공유하여 개발자 모드로 설치 가능합니다.

## 📄 라이선스

이 프로젝트는 개인 프로젝트입니다.

## 🔗 관련 링크

- [Frontend Documentation](/frontend/README.md)
- [Backend API Documentation](/workers/README.md)
- [Live Web App](https://im.hmpc.uk)
- [Chrome Extension 개발 문서](https://developer.chrome.com/docs/extensions/)
